/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.item.chiseled.IChiseledBlockItem;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.modification.operation.IModificationOperation;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.util.BlockStateUtils;
import mod.chiselsandbits.api.util.HelpTextUtils;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.item.multistate.SingleBlockMultiStateItemStack;
import mod.chiselsandbits.multistate.snapshot.SimpleSnapshot;
import mod.chiselsandbits.registrars.ModModificationOperation;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiseledBlockItem
extends class_1747
implements IChiseledBlockItem {
    private static final Supplier<class_1799> DEFAULT_INSTANCE = Suppliers.memoize(() -> {
        Random random = new Random();
        int blockStateCount = StateEntrySize.current().getBitsPerBlockSide() / 4 * (StateEntrySize.current().getBitsPerBlockSide() / 4) * (StateEntrySize.current().getBitsPerBlockSide() / 4);
        ArrayList<BlockInformation> blockInformation = new ArrayList<BlockInformation>(blockStateCount);
        for (int i = 0; i < blockStateCount; ++i) {
            blockInformation.add(BlockStateUtils.getRandomSupportedInformation(random));
        }
        SimpleSnapshot results = new SimpleSnapshot(BlockInformation.AIR);
        results.mutableStream().forEach(stateEntryInfo -> {
            class_243 pos = stateEntryInfo.getStartPoint().method_18806(StateEntrySize.current().getBitsPerBlockSideScalingVector());
            class_243 indexPos = pos.method_18805(0.25, 0.25, 0.25);
            class_2382 index = new class_2382(indexPos.method_10216(), indexPos.method_10214(), indexPos.method_10215());
            int size = StateEntrySize.current().getBitsPerBlockSide() / 4;
            int blockInformationIndex = index.method_10263() + index.method_10264() * size + index.method_10260() * size * size;
            BlockInformation info = (BlockInformation)blockInformation.get(blockInformationIndex);
            stateEntryInfo.overrideState(info);
        });
        class_1799 stack = results.toItemStack().toBlockStack();
        stack.method_7948().method_10556("default_instance_indicator", true);
        return stack;
    });

    public ChiseledBlockItem(class_2248 blockIn, class_1792.class_1793 builder) {
        super(blockIn, builder);
    }

    @NotNull
    public class_2561 method_7864(@NotNull class_1799 stack) {
        if (stack.method_7948().method_10545("default_instance_indicator") && stack.method_7948().method_10577("default_instance_indicator")) {
            return LocalStrings.DefaultChiseledBlockItemName.getText();
        }
        return super.method_7864(stack);
    }

    @Override
    @NotNull
    public IMultiStateItemStack createItemStack(class_1799 stack) {
        return new SingleBlockMultiStateItemStack(stack);
    }

    @NotNull
    public class_1269 method_7712(@NotNull class_1750 context) {
        IMultiStateItemStack source = this.createItemStack(context.method_8041());
        IWorldAreaMutator areaMutator = context.method_8036().method_18276() ? IMutatorFactory.getInstance().covering((class_1936)context.method_8045(), context.method_17698(), context.method_17698().method_1031(1.0, 1.0, 1.0)) : IMutatorFactory.getInstance().in((class_1936)context.method_8045(), context.method_8037());
        IMultiStateSnapshot attemptTarget = areaMutator.createSnapshot();
        boolean noCollisions = ((Stream)source.stream().sequential()).allMatch(stateEntryInfo -> {
            try {
                attemptTarget.setInAreaTarget(stateEntryInfo.getBlockInformation(), stateEntryInfo.getStartPoint());
                return true;
            }
            catch (SpaceOccupiedException exception) {
                return false;
            }
        });
        if (noCollisions) {
            try (IBatchMutation ignored = areaMutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(context.method_8036()));){
                ((Stream)source.stream().sequential()).forEach(stateEntryInfo -> {
                    try {
                        areaMutator.setInAreaTarget(stateEntryInfo.getBlockInformation(), stateEntryInfo.getStartPoint());
                    }
                    catch (SpaceOccupiedException spaceOccupiedException) {
                        // empty catch block
                    }
                });
            }
            if (context.method_8036() == null || !context.method_8036().method_7337()) {
                context.method_8041().method_7934(1);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 worldIn, @NotNull List<class_2561> tooltip, @NotNull class_1836 flagIn) {
        super.method_7851(stack, worldIn, tooltip, flagIn);
        HelpTextUtils.build(LocalStrings.HelpBitBag, tooltip, new Object[0]);
    }

    @Override
    public boolean canPlace(class_1799 heldStack, class_1657 playerEntity, class_3965 blockRayTraceResult) {
        IMultiStateItemStack source = this.createItemStack(heldStack);
        class_243 target = this.getTargetedBlockPos(heldStack, playerEntity, blockRayTraceResult);
        IWorldAreaMutator areaMutator = IMutatorFactory.getInstance().covering((class_1936)playerEntity.field_6002, target, target.method_1031(1.0, 1.0, 1.0));
        IMultiStateSnapshot attemptTarget = areaMutator.createSnapshot();
        return source.stream().allMatch(stateEntryInfo -> {
            try {
                attemptTarget.setInAreaTarget(stateEntryInfo.getBlockInformation(), stateEntryInfo.getStartPoint());
                return true;
            }
            catch (SpaceOccupiedException exception) {
                return false;
            }
        });
    }

    @NotNull
    public class_1799 method_7854() {
        return DEFAULT_INSTANCE.get();
    }

    @Override
    @NotNull
    public IModificationOperation getMode(class_1799 stack) {
        return ModModificationOperation.ROTATE_AROUND_X.get();
    }

    @Override
    public void setMode(class_1799 stack, IModificationOperation mode) {
        IMultiStateItemStack multiStateItemStack = this.createItemStack(stack);
        mode.apply(multiStateItemStack);
    }

    @Override
    @NotNull
    public Collection<IModificationOperation> getPossibleModes() {
        return ModModificationOperation.REGISTRY_SUPPLIER.get().getValues();
    }

    @Override
    public boolean requiresUpdateOnClosure() {
        return false;
    }
}

